/**
* \file: TtsAudioChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for navigation text to speech
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <string>
#include <adit_logging.h>
#include <bdcl/AilAudioSink.h>

#include "NaviTtsAudioChannel.h"

LOG_IMPORT_CONTEXT(tbdcl)

// todo check return values of the calles methods

namespace adit { namespace bdcl {

// todo replace raw ptr with smart ptr
NaviTtsAudioChannel::NaviTtsAudioChannel(CoreCallbackDealer* inCallbackDealer)
{
    mAudioSink = new AilAudioSink(this, inCallbackDealer);

    /* set config items */
    mAudioSink->setConfigItem("audio-playback-device", "device=alert periodms=8 inittoutms=2000");
    mAudioSink->setConfigItem("audio-sink-stream-type", "AUDIO_STREAM_NAVI_TTS");
    mAudioSink->setConfigItem("audio-sink-threshold-ms", "100");
    mAudioSink->setConfigItem("audio-sink-buffer-max-ms", "7000");
    mAudioSink->setConfigItem("disable-real-time-priority-audio", "0");
    mAudioSink->setConfigItem("audio-threads-real-time-priority", "61");
    mAudioSink->setConfigItem("audio-sink-channels", "1");
    mAudioSink->setConfigItem("audio-sink-bits-per-sample", "16");
    mAudioSink->setConfigItem("audio-sink-sampling-rate", "16000");

    mAudioSink->initialize();
}

NaviTtsAudioChannel::~NaviTtsAudioChannel()
{
    mAudioSink->teardown();
    delete mAudioSink;
}

void NaviTtsAudioChannel::onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig, unsigned int inSampleFormat)
{
    mAudioSink->setConfigItem("audio-sink-sampling-rate", std::to_string(inSampleRate));
    mAudioSink->setConfigItem("audio-sink-channels", std::to_string(inChannelConfig));
    mAudioSink->setConfigItem("audio-sink-bits-per-sample", std::to_string(inSampleFormat));

    mAudioSink->initialize();

    mAudioSink->playbackStart();
}

void NaviTtsAudioChannel::onPlaybackStop()
{
    mAudioSink->playbackStop(false);
}

void NaviTtsAudioChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_ERROR((tbdcl, "Error: %d on Navi TTS audio channel", static_cast<uint32_t>(inErrorCode)));
}

} } /* namespace adit { namespace bdcl */
